/*
 * Decompiled with CFR 0.152.
 */
package lib.toma.animations.api.event;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.network.NetworkManager;
import dev.toma.gunsrpg.network.packet.C2S_PlaySoundFromAnimationEventPacket;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lib.toma.animations.api.IAnimation;
import lib.toma.animations.api.event.AnimationEventType;
import lib.toma.animations.api.event.FlowDirection;
import lib.toma.animations.api.event.IAnimationDirectionProvider;
import lib.toma.animations.api.event.IAnimationEvent;
import lib.toma.animations.api.event.IAnimationEventSerializer;
import lib.toma.animations.engine.AbstractAnimationEvent;
import lib.toma.animations.engine.screen.SelectionButton;
import lib.toma.animations.engine.screen.animator.dialog.EventCreateDialog;
import lib.toma.animations.engine.screen.animator.dialog.EventDialogContext;
import lib.toma.animations.engine.screen.animator.dialog.SuggestionResponder;
import lib.toma.animations.engine.screen.animator.widget.ListView;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.widget.Slider;
import net.minecraftforge.registries.ForgeRegistries;

public class SoundAnimationEvent
extends AbstractAnimationEvent {
    private final SoundEvent sound;
    private final float volume;
    private final float pitch;
    private final FlowDirection direction;

    protected SoundAnimationEvent(AnimationEventType<? extends SoundAnimationEvent> type, float target, SoundEvent sound, float volume, float pitch, FlowDirection direction) {
        super(type, target);
        this.sound = sound;
        this.volume = volume;
        this.pitch = pitch;
        this.direction = direction;
    }

    public SoundAnimationEvent(float target, SoundEvent sound, float volume, float pitch, FlowDirection direction) {
        this(AnimationEventType.SOUND, target, sound, volume, pitch, direction);
    }

    @Override
    public void dispatch(Minecraft client, IAnimation fromAnimation) {
        if (fromAnimation instanceof IAnimationDirectionProvider) {
            FlowDirection direction = ((IAnimationDirectionProvider)((Object)fromAnimation)).getDirection();
            if (this.direction.isMatch(direction)) {
                this.play(client);
            }
        } else {
            this.play(client);
        }
    }

    private void play(Minecraft client) {
        client.field_71439_g.func_184185_a(this.sound, this.volume, this.pitch);
        NetworkManager.sendServerPacket(new C2S_PlaySoundFromAnimationEventPacket(this.sound.getRegistryName(), this.volume / 2.0f, this.pitch));
    }

    @Override
    public IAnimationEvent copyAt(float target) {
        return new SoundAnimationEvent(target, this.sound, this.volume, this.pitch, this.direction);
    }

    public static class AddSoundEventDialog
    extends EventCreateDialog<SoundAnimationEvent> {
        private Slider volumeSlider;
        private Slider pitchSlider;
        private SoundEvent selectedSound;
        private ListView<SoundEvent> soundSelector;
        private SelectionButton<FlowDirection> directionSelector;

        public AddSoundEventDialog(EventDialogContext<SoundAnimationEvent> context) {
            super(context);
        }

        @Override
        protected SoundAnimationEvent construct() {
            EventDialogContext context = this.getContext();
            float volume = (float)this.volumeSlider.getValue();
            float pitch = (float)this.pitchSlider.getValue();
            FlowDirection direction = this.directionSelector.getValue();
            return new SoundAnimationEvent(context.getTarget(), this.selectedSound, volume, pitch, direction);
        }

        @Override
        protected void preInit() {
            this.setDimensions(this.field_230708_k_ - 20, 240);
        }

        @Override
        protected void addWidgets() {
            int elWidth = this.dWidth() - 10;
            int btWidth = (elWidth - 5) / 2;
            TextFieldWidget soundFilter = (TextFieldWidget)this.func_230480_a_((Widget)new TextFieldWidget(this.field_230712_o_, this.left() + 5, this.top() + 15, elWidth, 20, StringTextComponent.field_240750_d_));
            soundFilter.func_212954_a((Consumer)new SuggestionResponder("Find sound", soundFilter, this::soundFilter_change));
            List sortedSoundList = ForgeRegistries.SOUND_EVENTS.getValues().stream().sorted(Comparator.comparing(SoundEvent::func_187503_a, ResourceLocation::compareNamespaced)).collect(Collectors.toList());
            this.soundSelector = (ListView)this.func_230480_a_(new ListView(this.left() + 5, this.top() + 40, elWidth, 120, sortedSoundList));
            this.soundSelector.setResponder(this::sound_select);
            this.soundSelector.setFormatter(sound -> sound.getRegistryName().toString());
            this.volumeSlider = (Slider)this.func_230480_a_((Widget)new Slider(this.left() + 5, this.top() + 165, elWidth, 20, (ITextComponent)new StringTextComponent("Volume: "), StringTextComponent.field_240750_d_, 0.0, 1.0, 1.0, true, true, btn -> {}));
            this.pitchSlider = (Slider)this.func_230480_a_((Widget)new Slider(this.left() + 5, this.top() + 190, btWidth, 20, (ITextComponent)new StringTextComponent("Pitch: "), StringTextComponent.field_240750_d_, 0.0, 1.0, 1.0, true, true, btn -> {}));
            this.directionSelector = ((SelectionButton)this.func_230480_a_(new SelectionButton<FlowDirection>(this.left() + 10 + btWidth, this.top() + 190, btWidth, 20, FlowDirection.values()))).formatter(FlowDirection::format);
            this.cancel = (Button)this.func_230480_a_((Widget)new Button(this.left() + 5, this.top() + 215, btWidth, 20, CANCEL, this::cancel_clicked));
            this.confirm = (Button)this.func_230480_a_((Widget)new Button(this.left() + 10 + btWidth, this.top() + 215, btWidth, 20, CONFIRM, this::confirm_clicked));
            this.updateConfirmButton();
        }

        private void soundFilter_change(String value) {
            this.soundSelector.setFilter(sound -> value == null || value.isEmpty() || sound.getRegistryName().toString().contains(value));
        }

        private void sound_select(SoundEvent event) {
            this.selectedSound = event;
            this.updateConfirmButton();
        }

        private void updateConfirmButton() {
            if (this.confirm != null) {
                this.confirm.field_230693_o_ = this.selectedSound != null;
            }
        }
    }

    public static final class Serializer
    implements IAnimationEventSerializer<SoundAnimationEvent> {
        @Override
        public JsonElement serialize(SoundAnimationEvent event, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            object.addProperty("sound", event.sound.getRegistryName().toString());
            object.addProperty("volume", (Number)Float.valueOf(event.volume));
            object.addProperty("pitch", (Number)Float.valueOf(event.pitch));
            object.addProperty("direction", (Number)event.direction.ordinal());
            return object;
        }

        @Override
        public SoundAnimationEvent deserialize(float target, JsonElement src, JsonDeserializationContext context) throws JsonParseException {
            if (!src.isJsonObject()) {
                throw new JsonSyntaxException("Not a Json object!");
            }
            JsonObject object = src.getAsJsonObject();
            ResourceLocation location = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"sound"));
            SoundEvent event = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location);
            if (event == null) {
                throw new JsonSyntaxException("Unknown sound: " + location);
            }
            float volume = JSONUtils.func_151221_a((JsonObject)object, (String)"volume", (float)1.0f);
            float pitch = JSONUtils.func_151221_a((JsonObject)object, (String)"pitch", (float)1.0f);
            FlowDirection direction = FlowDirection.byId(JSONUtils.func_151208_a((JsonObject)object, (String)"direction", (int)0));
            return new SoundAnimationEvent(target, event, volume, pitch, direction);
        }
    }
}

